﻿var importHistory = {
    context: $(".h-importationHistory"),
    datatable: null,
    refreshDataTable: function () {
        importHistory.datatable.a4datatable("refresh");
    },
    initializeDataTable: function () {
        this.datatable = $(".h-importHistoryTable", importHistory.context).a4datatable({
            ajaxAction: a4.getProjectAction("GetImportationHistory", "Importation"),
            columns: [
                { "Name": "ActionId", "Title": resources.Id },
                { "Name": "DataSourceName", "Title": resources.DataSourceName },
                { "Name": "CaseCount", "Title": resources.Count },
                { "Name": "FirstCase", "Title": resources.FirstCase },
                { "Name": "LastCase", "Title": resources.LastCase },
                { "Name": "Modified", "Title": resources.DateTime },
                { "Name": "ModifiedBy", "Title": resources.User }
            ],
            stateKey: "ImportationHistory"
        });
    },
    bindEvents: function () {
        var options = { afterClose: function () { importHistory.refreshDataTable(); } };

        importHistory.context.on("click", ".h-cancel-lastwave", function () {
            modalDialog.showConfirmDialog(confirmCancelImportationWaveResources, function () {
                a4.callServerMethod(a4.getProjectAction("CancelLastWave", "Importation"), {},
                    function (result) {
                        importHistory.refreshDataTable();
                    });
            }, 250, 400, false);
        });
    }
}

$(document).ready(function () {
    if (importHistory.context.length > 0) {
        importHistory.initializeDataTable();
        importHistory.bindEvents();
    }
});